﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private CompetencePartBL _CompetencePartBL = null;

        public CompetencePartBL CompetencePart
        {
            get
            {
                if (_CompetencePartBL == null)
                {
                    _CompetencePartBL = new CompetencePartBL(this);
                }

                return _CompetencePartBL;
            }
        }

        public class CompetencePartBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public CompetencePartBL(ZSBELearning BL) : base(BL) { }

            public List<BO.CompetencePart> Restore()
            {
                return BLP.DAL.CompetencePart.Restore();
            }

            public List<BO.CompetencePart> Restore(BO.CompetencePart.Search Search)
            {
                return BLP.DAL.CompetencePart.Restore(Search);
            }

            public BO.CompetencePart Restore(long? ID)
            {
                return BLP.DAL.CompetencePart.Restore(ID);
            }

            public BO.CompetencePart Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                return BLP.DAL.CompetencePart.Restore(BO.ID);
            }

            public BO.CompetencePart Restore(BO.Student Student)
            {
                return BLP.DAL.CompetencePart.Restore(Student);
            }

            public BO.CompetencePart New(string Name, BO.Competence Competence)
            {
                BO.CompetencePart _new = null;

                if ((!String.IsNullOrEmpty(Name) && (Competence != null) && (Competence.ID.HasValue)))
                {
                    BO.CompetencePart.Search _search = new BO.CompetencePart.Search();
                    _search.CompetenceID = Competence.ID;

                    _new = BLP.DAL.CompetencePart.New();
                    _new.IsActive = false;
                    _new.IsValid = false;
                    _new.Name = Name;
                    _new.CompetenceID = Competence.ID;
                    _new.Weight = BLP.DAL.CompetencePart.Count(_search) + 1;

                    if (BLP.DAL.CompetencePart.Create(_new))
                    {
                        // dodawanie kompetencji skladowej do wszystkich klas
                        List<BO.Class> _listClass = BLP.DAL.Class.Restore();
                        foreach (BO.Class _loopClass in _listClass)
                        {
                            BO.CompetencePart_Class _CompetencePart_Class = BLP.DAL.CompetencePart_Class.New();
                            _CompetencePart_Class.ClassID = _loopClass.ID;
                            _CompetencePart_Class.CompetencePartID = _new.ID;
                            _CompetencePart_Class.IsAvailable = _new.IsActive == true && _new.IsValid == true;
                            BLP.DAL.CompetencePart_Class.Create(_CompetencePart_Class);
                        }
                    }
                }

                return _new;
            }

            public List<BO.CompetencePart> Restore(BO.Competence Competence)
            {
                BO.CompetencePart.Search _Search = new BO.CompetencePart.Search();
                _Search.CompetenceID = Competence.ID;

                return BLP.DAL.CompetencePart.Restore(_Search);
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.CompetencePart CompetencePart)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (CompetencePart == null)
                {
                    _methodResult.SetSuccess = false;
                }
                else
                {
                    if (CompetencePart.ID.HasValue)
                    {
                        _methodResult.SetSuccess = BLP.DAL.CompetencePart.Update(CompetencePart);
                    }
                    else
                    {
                        _methodResult.SetSuccess = BLP.DAL.CompetencePart.Create(CompetencePart);
                        if (_methodResult.Success)
                        {
                            // dodawanie kompetencji skladowej do wszystkich klas
                            List<BO.Class> _listClass = BLP.DAL.Class.Restore();
                            foreach (BO.Class _loopClass in _listClass)
                            {
                                BO.CompetencePart_Class _CompetencePart_Class = BLP.DAL.CompetencePart_Class.New();
                                _CompetencePart_Class.ClassID = _loopClass.ID;
                                _CompetencePart_Class.CompetencePartID = CompetencePart.ID;
                                _CompetencePart_Class.IsAvailable = CompetencePart.IsActive == true && CompetencePart.IsValid == true;
                                BLP.DAL.CompetencePart_Class.Create(_CompetencePart_Class);
                            }
                        }
                    }
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.View.CompetencePart CompetencePart)
            {
                return Remove(Restore(CompetencePart));
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.CompetencePart CompetencePart)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                PI.GM.N610.ELearning.BL.BO.Course _course = BLP.BLELearning.Course.Restore(CompetencePart.CompetenceCourseID);
                _methodResult.SetSuccess = BLP.BLELearning.Statistic.Course.Remove(_course);

                _course = BLP.BLELearning.Course.Restore(CompetencePart.CompetenceTheoryID);
                _methodResult.SetSuccess = BLP.BLELearning.Statistic.Course.Remove(_course);

                _course = BLP.BLELearning.Course.Restore(CompetencePart.CaseID);
                _methodResult.SetSuccess = BLP.BLELearning.Statistic.Course.Remove(_course);

                BO.Competence _Competence = BLP.DAL.Competence.Restore(CompetencePart.CompetenceID);

                if (_Competence != null)
                {
                    _methodResult.SetSuccess = RefresWeight(_Competence);
                }

                // usuwanie kompetencji skladowych z wszystkich klas
                BO.CompetencePart_Class.Search _searchCompetencePart_Class = new BO.CompetencePart_Class.Search();
                _searchCompetencePart_Class.EditDate = new FM.N000.Base.BL.BO.DateRange(System.DateTime.Now);
                _searchCompetencePart_Class.EditUser = BLP.Environment.User.ID;
                _searchCompetencePart_Class.CompetencePartID = CompetencePart.ID;
                _methodResult.SetSuccess = BLP.DAL.CompetencePart_Class.Remove(_searchCompetencePart_Class);


                _methodResult.SetSuccess = BLP.DAL.CompetencePart.Remove(CompetencePart);

                return _methodResult;
            }

            public bool RefresWeight(BO.Competence Competence)
            {
                bool _return = true;

                BO.CompetencePart.Search _Search = new BO.CompetencePart.Search();
                _Search.CompetenceID = Competence.ID;

                List<BO.CompetencePart> _listCompetencePart = BLP.DAL.CompetencePart.Restore(_Search);

                int _weight = 1;
                foreach (BO.CompetencePart _loopCompetencePart in _listCompetencePart)
                {
                    _loopCompetencePart.Weight = _weight;
                    _return &= BLP.DAL.CompetencePart.Update(_loopCompetencePart);
                    _weight++;
                }

                return _return;
            }

            public bool Switch(BO.View.CompetencePart CompetencePartA, BO.View.CompetencePart CompetencePartB)
            {
                bool _return = true;

                BO.CompetencePart _CompetencePartA = Restore(CompetencePartA);
                BO.CompetencePart _CompetencePartB = Restore(CompetencePartB);

                _CompetencePartA.Weight = CompetencePartB.Weight;
                _CompetencePartB.Weight = CompetencePartA.Weight;

                _return &= Save(_CompetencePartA).Success;
                _return &= Save(_CompetencePartB).Success;

                CompetencePartA.Weight = _CompetencePartA.Weight;
                CompetencePartB.Weight = _CompetencePartB.Weight;

                return _return;
            }

            public int Count()
            {
                return BLP.DAL.CompetencePart.Count();
            }

            private ViewBL _view = null;

            public ViewBL View
            {
                get
                {
                    if (_view == null)
                    {
                        _view = new ViewBL(this.BLP);
                    }
                    return _view;
                }
            }

            public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
            {
                public ViewBL(ZSBELearning BL) : base(BL) { }

                public List<BO.View.CompetencePart> Restore()
                {
                    return BLP.DAL.CompetencePartView.Restore();
                }

                public List<BO.View.CompetencePart> Restore(BO.CompetencePart.Search Search)
                {
                    return BLP.DAL.CompetencePartView.Restore(Search);
                }

                public Gemini.Core.BL.Interface.BO.IBaseUnique<long?> RestoreByID(long? ID)
                {
                    return BLP.DAL.CompetencePartView.Restore(ID);
                }

                public BO.View.CompetencePart Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
                {
                    return BLP.DAL.CompetencePartView.Restore(BO.ID);
                }
            }

            private ClassBL _ClassBL = null;

            public ClassBL Class
            {
                get
                {
                    if (_ClassBL == null)
                    {
                        _ClassBL = new ClassBL(this.BLP);
                    }
                    return _ClassBL;
                }
            }

            public class ClassBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public ClassBL(ZSBELearning BL) : base(BL) { }

                public BO.CompetencePart_Class New()
                {
                    return BLP.DAL.CompetencePart_Class.New();
                }

                public Gemini.Core.BL.Base.MethodResult Save(BO.CompetencePart_Class CompetencePart_Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    if (CompetencePart_Class == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        if (CompetencePart_Class.ID.HasValue)
                        {
                            _methodResult.SetSuccess = BLP.DAL.CompetencePart_Class.Update(CompetencePart_Class);
                        }
                        else
                        {
                            _methodResult.SetSuccess = BLP.DAL.CompetencePart_Class.Create(CompetencePart_Class);
                        }
                    }
                    return _methodResult;
                }

                public Gemini.Core.BL.Base.MethodResult Remove(BO.CompetencePart_Class CompetencePart_Class)
                {
                    Gemini.Core.BL.Base.MethodResult _result = new Gemini.Core.BL.Base.MethodResult(BLP.DAL.CompetencePart_Class.Remove(CompetencePart_Class));
                    return _result;
                }

                public Gemini.Core.BL.Base.MethodResult Remove(BO.Class Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    if (Class != null)
                    {
                        try
                        {
                            BO.CompetencePart_Class.Search _search = new BO.CompetencePart_Class.Search();
                            _search.ClassID = Class.ID;

                            _methodResult.SetSuccess = BLP.DAL.CompetencePart_Class.Remove(_search);

                            if (!_methodResult.Success)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                            }
                        }
                        catch (Exception _exception)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                        }
                    }
                    return _methodResult;
                }

                public Gemini.Core.BL.Base.MethodResult Create(BO.Class Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    if (Class != null)
                    {
                        try
                        {
                            List<BO.CompetencePart> _listCompetencePart = BLP.CompetencePart.Restore();
                            foreach (BO.CompetencePart _loopCompetencePart in _listCompetencePart)
                            {
                                BO.CompetencePart_Class _CompetencePart_Class = New();

                                _CompetencePart_Class.ClassID = Class.ID;
                                _CompetencePart_Class.CompetencePartID = _loopCompetencePart.ID;
                                _CompetencePart_Class.IsAvailable = false;

                                _methodResult.Add(Save(_CompetencePart_Class));
                            }

                            if (!_methodResult.Success)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Failed.Value, false);
                            }
                        }
                        catch (Exception _exception)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Exception.Value, _exception);
                        }
                    }
                    return _methodResult;
                }

                public bool IsAvailable(BO.CompetencePart CompetencePart,BO.Class Class)
                {
                    bool _return = false;

                    BO.CompetencePart_Class.Search _search = new BO.CompetencePart_Class.Search();
                    _search.ClassID = Class.ID;
                    _search.CompetencePartID = CompetencePart.ID;

                    BO.CompetencePart_Class _CompetencePart_Class = BLP.DAL.CompetencePart_Class.RestoreTopOne(_search);

                    if (_CompetencePart_Class != null)
                    {
                        _return = _CompetencePart_Class.IsAvailable ?? false;
                    }

                    return _return;
                }

                public int Count()
                {
                    return BLP.DAL.CompetencePart_Class.Count();
                }

                private ViewBL _view = null;

                public ViewBL View
                {
                    get
                    {
                        if (_view == null)
                        {
                            _view = new ViewBL(this.BLP);
                        }
                        return _view;
                    }
                }

                public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
                {
                    public ViewBL(ZSBELearning BL) : base(BL) { }

                    public List<BO.View.CompetencePart_Class> Restore()
                    {
                        return BLP.DAL.CompetencePart_ClassView.Restore();
                    }

                    public List<BO.View.CompetencePart_Class> Restore(BO.CompetencePart_Class.Search Search)
                    {
                        return BLP.DAL.CompetencePart_ClassView.Restore(Search);
                    }
                }
            }
        }
    }
}
